package org.msh.tb.bd.dashboard.detailedrep;

import org.msh.tb.bd.dashboard.query.IndicatorQuery;
import org.msh.tb.indicators.core.Indicator2D;
import org.msh.utils.reportgen.highchart.ChartCreator;

/**
 * Created by Mauricio on 20/05/2017.
 * Manage the generic aspects when generating the detailed report of dashboard indicators.
 */
public abstract class DetailedIndicator<E extends IndicatorQuery> extends Indicator2D {

    protected ChartCreator chartCreator;

    private E indicatorQuery;

    /**
     * @return a Indicator Query instance initialized to be used to get information from database
     */
    protected E getQuery() {
        if (indicatorQuery == null) {
            indicatorQuery = getQueryNewInstance();
            indicatorQuery.setEntityManager(getEntityManager());
            indicatorQuery.setWorkspace(getWorkspace());
        }

        return indicatorQuery;
    }

    /**
     * @return a brand new instance of the indicator query used by this detailed report implementation
     */
    protected abstract E getQueryNewInstance();

    /**
     * Created the chartdata based on the table created on this report
     */
    protected abstract void createChartData();

    /**
     * Return chart data
     * @return
     */
    public String getChartData() {
        if (chartCreator == null) {
            createChartData();
        }

        return chartCreator.getJsonOptions();
    }
}
